package factories

import (
	"time"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/testutils"
)

type ThreadStationFactory struct {
	thread        *rasp.TThread
	station       *rasp.TStation
	threadStation *rasp.TThreadStation
	repoRegistry  *registry.RepositoryRegistry
}

func NewThreadStationFactory(repoRegistry *registry.RepositoryRegistry) *ThreadStationFactory {
	threadStation := &rasp.TThreadStation{
		Id:               testutils.Counter.Int32(),
		IsSearchableFrom: true,
		IsSearchableTo:   true,
	}
	return &ThreadStationFactory{
		threadStation: threadStation,
		repoRegistry:  repoRegistry,
	}
}

func (f *ThreadStationFactory) Create() *rasp.TThreadStation {
	if f.thread == nil {
		f.thread = NewThreadFactory(f.repoRegistry).Create()
	}
	f.threadStation.ThreadId = f.thread.Id

	if f.station == nil {
		f.station = NewStationFactory(f.repoRegistry).Create()
	}
	f.threadStation.StationId = f.station.Id

	if f.threadStation.TimeZoneId == 0 {
		f.threadStation.TimeZoneId = NewTimeZoneFactory(f.repoRegistry).Create().Id
	}

	f.repoRegistry.GetThreadStationRepo().Add(f.threadStation)
	return f.threadStation
}

func (f *ThreadStationFactory) WithDeparture(tz time.Duration) *ThreadStationFactory {
	f.threadStation.DepartureTz = int64(tz.Minutes())
	f.threadStation.HasDeparture = true
	return f
}

func (f *ThreadStationFactory) WithArrival(tz time.Duration) *ThreadStationFactory {
	f.threadStation.ArrivalTz = int64(tz.Minutes())
	f.threadStation.HasArrival = true
	return f
}

func (f *ThreadStationFactory) WithThread(thread *rasp.TThread) *ThreadStationFactory {
	f.thread = thread
	return f
}

func (f *ThreadStationFactory) WithStation(station *rasp.TStation) *ThreadStationFactory {
	f.station = station
	return f
}

func (f *ThreadStationFactory) WithTimeZone(tz *rasp.TTimeZone) *ThreadStationFactory {
	f.threadStation.TimeZoneId = tz.Id
	return f
}
