package factories

import (
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/consts"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/testutils"
)

type TimeZoneFactory struct {
	zone         *rasp.TTimeZone
	repoRegistry *registry.RepositoryRegistry
}

func NewTimeZoneFactory(repoRegistry *registry.RepositoryRegistry) *TimeZoneFactory {
	zone := &rasp.TTimeZone{
		Id:   testutils.Counter.Int32(),
		Code: consts.UTCCode,
	}
	return &TimeZoneFactory{
		zone:         zone,
		repoRegistry: repoRegistry,
	}
}

func (f *TimeZoneFactory) Create() *rasp.TTimeZone {
	repo := f.repoRegistry.GetTimeZoneRepo()
	if zone, found := repo.GetByCode(f.zone.Code); found {
		return zone
	}
	repo.Add(f.zone)
	return f.zone
}

func (f *TimeZoneFactory) WithCode(code string) *TimeZoneFactory {
	f.zone.Code = code
	return f
}
