package localexts

import (
	"strings"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type NamedTrainByNumber struct {
	index map[string]*rasp.TNamedTrain
}

func NewNamedTrainByNumber() *NamedTrainByNumber {
	return &NamedTrainByNumber{
		index: make(map[string]*rasp.TNamedTrain),
	}
}

func (ext *NamedTrainByNumber) AddProto(message proto.Message) {
	if message == nil {
		return
	}

	train, ok := message.(*rasp.TNamedTrain)
	if !ok {
		return
	}

	for _, number := range strings.Split(train.Numbers, "/") {
		ext.index[number] = train
	}
}

func (ext *NamedTrainByNumber) GetByNumber(number string) (*rasp.TNamedTrain, bool) {
	train, ok := ext.index[number]
	return train, ok
}
