package localexts

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CapitalByRegionID struct {
	byRegionID map[int32]*rasp.TSettlement
}

func NewCapitalByRegionID() *CapitalByRegionID {
	return &CapitalByRegionID{
		byRegionID: make(map[int32]*rasp.TSettlement),
	}
}

func (ext *CapitalByRegionID) AddProto(message proto.Message) {
	if message == nil {
		return
	}

	settlement, ok := message.(*rasp.TSettlement)
	if !ok {
		return
	}

	if settlement.Majority > rasp.TSettlement_MAJORITY_REGION_CAPITAL || settlement.RegionId == 0 || settlement.IsHidden {
		return
	}
	ext.byRegionID[settlement.RegionId] = settlement
}

func (ext *CapitalByRegionID) GetCapitalByRegionID(id int32) (*rasp.TSettlement, bool) {
	settlement, ok := ext.byRegionID[id]
	return settlement, ok
}

type CapitalByCountryID struct {
	index map[int32]*rasp.TSettlement
}

func NewCapitalByCountryID() *CapitalByCountryID {
	return &CapitalByCountryID{
		index: make(map[int32]*rasp.TSettlement),
	}
}

func (ext *CapitalByCountryID) AddProto(message proto.Message) {
	if message == nil {
		return
	}

	settlement, ok := message.(*rasp.TSettlement)
	if !ok {
		return
	}

	if settlement.Majority != rasp.TSettlement_MAJORITY_CAPITAL || settlement.CountryId == 0 || settlement.IsHidden {
		return
	}
	ext.index[settlement.CountryId] = settlement
}

func (ext *CapitalByCountryID) GetCapitalByCountryID(id int32) (*rasp.TSettlement, bool) {
	settlement, ok := ext.index[id]
	return settlement, ok
}
