package localexts

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type AllStationBySettlement struct {
	allLinks []*rasp.TStation2Settlement
}

func NewAllStationBySettlement() *AllStationBySettlement {
	return &AllStationBySettlement{
		allLinks: make([]*rasp.TStation2Settlement, 0),
	}
}

func (ext *AllStationBySettlement) AddProto(message proto.Message) {
	link, ok := message.(*rasp.TStation2Settlement)
	if !ok {
		return
	}

	ext.allLinks = append(ext.allLinks, link)
}

func (ext *AllStationBySettlement) All() []*rasp.TStation2Settlement {
	return ext.allLinks
}
