package localexts

import (
	"time"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type LocationByTimeZoneID struct {
	logger    log.Logger
	locations map[int32]*time.Location
}

func NewLocationByTimeZoneID(logger log.Logger) *LocationByTimeZoneID {
	return &LocationByTimeZoneID{
		logger:    logger,
		locations: make(map[int32]*time.Location),
	}
}

func (ext *LocationByTimeZoneID) AddProto(message proto.Message) {
	if zone, ok := message.(*rasp.TTimeZone); ok {
		if location, err := time.LoadLocation(zone.Code); err != nil {
			ext.logger.Warn(
				"unknown timezone name",
				log.String("name", zone.Code),
				log.Error(err),
			)
		} else {
			ext.locations[zone.Id] = location
		}
	}
}

func (ext *LocationByTimeZoneID) GetLocationByID(id int32) (*time.Location, bool) {
	location, ok := ext.locations[id]
	return location, ok
}

func (ext *LocationByTimeZoneID) Localize(date time.Time, id int32) time.Time {
	if location, ok := ext.locations[id]; ok {
		return date.In(location)
	}
	return date
}
