package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CountryRepository struct {
	*base.Repository
	*extensions.CountryByID
	*extensions.CountryByGeoID
}

func NewCountryRepository() *CountryRepository {
	fn := func() proto.Message {
		return &rasp.TCountry{}
	}
	repo := &CountryRepository{
		Repository:     base.NewRepository("CountryRepository", fn),
		CountryByID:    extensions.NewCountryByID(),
		CountryByGeoID: extensions.NewCountryByGeoID(),
	}
	repo.AddExtensions(
		repo.CountryByID,
		repo.CountryByGeoID,
	)
	return repo
}
