package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type CurrencyRepository struct {
	*base.Repository
	*extensions.CurrencyByID
}

func NewCurrencyRepository() *CurrencyRepository {
	fn := func() proto.Message {
		return &rasp.TCurrency{}
	}
	repo := &CurrencyRepository{
		Repository:   base.NewRepository("CurrencyRepository", fn),
		CurrencyByID: extensions.NewCurrencyByID(),
	}
	repo.AddExtensions(
		repo.CurrencyByID,
	)
	return repo
}
