package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/localexts"
)

type NamedTrainRepository struct {
	*base.Repository
	*localexts.NamedTrainByNumber
}

func NewNamedTrainRepository() *NamedTrainRepository {
	fn := func() proto.Message {
		return &rasp.TNamedTrain{}
	}
	repo := &NamedTrainRepository{
		Repository:         base.NewRepository("NamedTrainRepository", fn),
		NamedTrainByNumber: localexts.NewNamedTrainByNumber(),
	}
	repo.AddExtensions(
		repo.NamedTrainByNumber,
	)
	return repo
}
