package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type RegionRepository struct {
	*base.Repository
	*extensions.RegionByID
}

func NewRegionRepository() *RegionRepository {
	fn := func() proto.Message {
		return &rasp.TRegion{}
	}
	repo := &RegionRepository{
		Repository: base.NewRepository("RegionRepository", fn),
		RegionByID: extensions.NewRegionByID(),
	}
	repo.AddExtensions(
		repo.RegionByID,
	)
	return repo
}
