package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type RouteRepository struct {
	*base.Repository
	*extensions.RouteByID
}

func NewRouteRepository() *RouteRepository {
	fn := func() proto.Message {
		return &rasp.TRoute{}
	}
	repo := &RouteRepository{
		Repository: base.NewRepository("RouteRepository", fn),
		RouteByID:  extensions.NewRouteByID(),
	}
	repo.AddExtensions(
		repo.RouteByID,
	)
	return repo
}
