package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/localexts"
)

type SettlementRepository struct {
	*base.Repository
	*extensions.SettlementByID
	*extensions.SettlementByGeoID
	*extensions.SettlementBySlug
	*localexts.CapitalByRegionID
	*localexts.CapitalByCountryID
}

func NewSettlementRepository() *SettlementRepository {
	fn := func() proto.Message {
		return &rasp.TSettlement{}
	}

	repo := &SettlementRepository{
		Repository:         base.NewRepository("SettlementRepository", fn),
		SettlementByID:     extensions.NewSettlementByID(),
		SettlementByGeoID:  extensions.NewSettlementByGeoID(),
		SettlementBySlug:   extensions.NewSettlementBySlug(),
		CapitalByRegionID:  localexts.NewCapitalByRegionID(),
		CapitalByCountryID: localexts.NewCapitalByCountryID(),
	}
	repo.AddExtensions(
		repo.SettlementByID,
		repo.SettlementByGeoID,
		repo.SettlementBySlug,
		repo.CapitalByRegionID,
		repo.CapitalByCountryID,
	)
	return repo
}
