package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationRepository struct {
	*base.Repository
	*extensions.StationByID
	*extensions.StationBySlug
}

func NewStationRepository() *StationRepository {
	fn := func() proto.Message {
		return &rasp.TStation{}
	}
	repo := &StationRepository{
		Repository:    base.NewRepository("StationRepository", fn),
		StationByID:   extensions.NewStationByID(),
		StationBySlug: extensions.NewStationBySlug(),
	}
	repo.AddExtensions(
		repo.StationByID,
		repo.StationBySlug,
	)
	return repo
}
