package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationCodeRepository struct {
	*base.Repository
	*extensions.StationCodesByStationID
	*extensions.StationCodesBySystemID
}

func NewStationCodeRepository() *StationCodeRepository {
	fn := func() proto.Message {
		return &rasp.TStationCode{}
	}
	repo := &StationCodeRepository{
		Repository:              base.NewRepository("StationCodeRepository", fn),
		StationCodesByStationID: extensions.NewStationCodesByStationID(),
		StationCodesBySystemID:  extensions.NewStationCodesBySystemID(),
	}
	repo.AddExtensions(
		repo.StationCodesByStationID,
		repo.StationCodesBySystemID,
	)
	return repo
}
