package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/localexts"
)

type StationToSettlementRepository struct {
	*base.Repository
	*localexts.AllStationBySettlement
}

func NewStationToSettlementRepository() *StationToSettlementRepository {
	fn := func() proto.Message {
		return &rasp.TStation2Settlement{}
	}
	repo := &StationToSettlementRepository{
		Repository:             base.NewRepository("StationToSettlementRepository", fn),
		AllStationBySettlement: localexts.NewAllStationBySettlement(),
	}
	repo.AddExtensions(
		repo.AllStationBySettlement,
	)
	return repo
}
