package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type ThreadRepository struct {
	*base.Repository
	*extensions.ThreadByID
}

func NewThreadRepository() *ThreadRepository {
	newFn := func() proto.Message {
		return new(rasp.TThread)
	}

	onlyTrainTransport := func(message proto.Message) bool {
		thread, ok := message.(*rasp.TThread)
		return ok && thread.TransportType == rasp.TTransport_TYPE_TRAIN
	}

	repo := &ThreadRepository{
		Repository: base.NewRepository("ThreadRepository", newFn).WithPredicate(onlyTrainTransport),
		ThreadByID: extensions.NewThreadByID(),
	}
	repo.AddExtensions(
		repo.ThreadByID,
	)
	return repo
}
