package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type ThreadStationRepository struct {
	*base.Repository
	*extensions.ThreadStationByID
	*extensions.ThreadStationByThreadID
}

func NewThreadStationRepository() *ThreadStationRepository {
	newFn := func() proto.Message {
		return new(rasp.TThreadStation)
	}
	repo := &ThreadStationRepository{
		Repository:              base.NewRepository("ThreadStationRepository", newFn),
		ThreadStationByID:       extensions.NewThreadStationByID(),
		ThreadStationByThreadID: extensions.NewThreadStationByThreadID(),
	}
	repo.AddExtensions(
		repo.ThreadStationByID,
		repo.ThreadStationByThreadID,
	)
	return repo
}
