package rasp

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/localexts"
)

type TimeZoneRepository struct {
	*base.Repository
	*extensions.TimeZoneByID
	*localexts.LocationByTimeZoneID
}

func NewTimeZoneRepository(logger log.Logger) *TimeZoneRepository {
	newFn := func() proto.Message {
		return new(rasp.TTimeZone)
	}
	repo := &TimeZoneRepository{
		Repository:           base.NewRepository("TimeZoneRepository", newFn),
		TimeZoneByID:         extensions.NewTimeZoneByID(),
		LocationByTimeZoneID: localexts.NewLocationByTimeZoneID(logger),
	}
	repo.AddExtensions(
		repo.TimeZoneByID,
		repo.LocationByTimeZoneID,
	)
	return repo
}
