package registry

import (
	"path"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/resourcestorage"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/updater"
)

type registration struct {
	dictKey  string
	dictType DictType
}

func NewRepositoryUpdater(
	cfg *dict.Config,
	logger log.Logger,
	resourceReader resourcestorage.StorageReader,
	registry *RepositoryRegistry,
) *updater.Updater {
	registrations := []registration{
		{"COUNTRY", Country},
		{"CURRENCY", Currency},
		{"NAMED_TRAIN", NamedTrain},
		{"REGION", Region},
		{"ROUTE", Route},
		{"SETTLEMENT", Settlement},
		{"SETTLEMENT_TO_STATION", StationToSettlement},
		{"STATION", Station},
		{"STATION_CODE", StationCode},
		{"THREAD", Thread},
		{"THREAD_STATION", ThreadStation},
		{"TIMEZONE", TimeZone},
	}

	dictUpdater := updater.NewUpdater("dicts", logger)
	for _, reg := range registrations {
		resourceKey := path.Join(cfg.S3DictPathPrefix, reg.dictKey)
		dictLoader := NewDictLoader(
			logger,
			resourceReader,
			registry.getUpdateFn(reg.dictType),
			resourceKey,
			registry.getSample(reg.dictType),
		)
		dictUpdater.AddUpdateRule(
			reg.dictKey,
			cfg.UpdateInterval,
			dictLoader.Load,
		)
	}
	return dictUpdater
}
