package registry

import (
	"sync/atomic"

	"github.com/golang/protobuf/proto"
)

type repo interface {
	Add(proto.Message)
	GetSample() proto.Message
}

type repoWrapper struct {
	code    DictType
	newRepo func() repo
	repoPtr atomic.Value
}

func newRepoWrapper(code DictType, newFn func() repo) *repoWrapper {
	w := &repoWrapper{
		code:    code,
		newRepo: newFn,
	}
	w.repoPtr.Store(newFn())
	return w
}

func (w *repoWrapper) loadRepo() repo {
	return w.repoPtr.Load().(repo)
}

func (w *repoWrapper) storeRepo(r repo) {
	w.repoPtr.Store(r)
}
