package experiments

import (
	"context"
	"strings"
)

type ctxKey struct{}

var experimentsKey = new(ctxKey)

func ParseExperiments(ctx context.Context, rawFlags string) context.Context {
	if len(rawFlags) == 0 {
		return ctx
	}

	flags := make(map[string]bool)
	for _, flag := range strings.Split(rawFlags, ",") {
		flags[flag] = true
	}

	return context.WithValue(ctx, experimentsKey, flags)
}

func UseTariffsInMemory(ctx context.Context) bool {
	return flagIsEnabled(ctx, "TRAVELWIZ-102/use-tariffs-in-memory")
}

func flagIsEnabled(ctx context.Context, flag string) bool {
	flags, ok := ctx.Value(experimentsKey).(map[string]bool)
	if !ok {
		return false
	}
	return flags[flag]
}
