package express

import (
	"strconv"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/traincity"
)

type Cache struct {
	logger              log.Structured
	repos               *registry.RepositoryRegistry
	trainCityRepository *traincity.Repository

	stationIDToExpressID map[int32]int
}

func NewCache(logger log.Structured, registry *registry.RepositoryRegistry, trainCityRepository *traincity.Repository) *Cache {
	return &Cache{
		logger:              logger,
		repos:               registry,
		trainCityRepository: trainCityRepository,

		stationIDToExpressID: make(map[int32]int),
	}
}

func (c *Cache) Build() *Cache {
	for _, code := range c.repos.GetStationCodeRepo().GetCodesBySystemID(rasp.ECodeSystem_CODE_SYSTEM_EXPRESS) {
		if code.StationId == 0 {
			continue
		}

		if expressID, err := strconv.Atoi(code.Code); err == nil {
			c.stationIDToExpressID[code.StationId] = expressID
		}
	}
	return c
}
