package geo

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/yandex/geobase"
)

var LinguisticsNotFound = xerrors.New("fakeGeobase: linguistics not found")

type FakeGeobaseClient struct {
	RegionByGeoID map[geobase.ID]*geobase.Region
}

func NewFakeGeobaseClient() *FakeGeobaseClient {
	return &FakeGeobaseClient{
		RegionByGeoID: make(map[geobase.ID]*geobase.Region),
	}
}

func (g *FakeGeobaseClient) GetRegionByID(id geobase.ID, crimea ...geobase.CrimeaStatus) (*geobase.Region, error) {
	if region, found := g.RegionByGeoID[id]; found {
		return region, nil
	}
	return nil, nil
}

func (g *FakeGeobaseClient) GetLinguistics(geobase.ID, string) (*geobase.Linguistics, error) {
	return nil, LinguisticsNotFound
}

func (g *FakeGeobaseClient) Destroy() {}

func (g *FakeGeobaseClient) AddRegions(regions ...*geobase.Region) {
	for _, region := range regions {
		g.RegionByGeoID[region.ID] = region
	}
}
