package geo

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/geobase"
)

type Config struct {
	Datafile string `config:"searchapi-geobase-path"`
	Enabled  bool   `config:"searchapi-geobase-enabled"`
}

var DefaultConfig = Config{
	Datafile: "",
	Enabled:  false,
}

type Geobase interface {
	GetRegionByID(id geobase.ID, crimea ...geobase.CrimeaStatus) (*geobase.Region, error)
	GetLinguistics(id geobase.ID, lang string) (*geobase.Linguistics, error)
	Destroy()
}

func NewGeobase(config *Config, logger log.Logger) (Geobase, error) {
	if !config.Enabled {
		return NewFakeGeobaseClient(), nil
	}

	g, err := geobase.New(
		geobase.WithDatafilePath(config.Datafile),
	)
	if err != nil {
		return nil, fmt.Errorf("cannot init geobase: %v", err)
	}
	logger.Infof("Geobase initialized with file %s", config.Datafile)

	return g, nil
}

func IsSettlementTypes(t geobase.RegionType) bool {
	return t == geobase.RegionTypeCity ||
		t == geobase.RegionTypeVillage
}
