package helpers

import (
	"regexp"
	"strings"
)

var replacingStringsMap = map[string]string{
	"ё":       "е",
	"ї":       "i",
	"\u0456":  "i",
	"ç":       "c",
	"ğ":       "g",
	"ı":       "i",
	"ö":       "o",
	"ş":       "s",
	"ü":       "u",
	"i\u0307": "i",
}

var removedSymbolsRE = regexp.MustCompile(`[№" ]+`)

func Normalize(text string) string {
	if len(text) == 0 {
		return text
	}
	text = strings.ToLower(text)
	for k, v := range replacingStringsMap {
		text = strings.ReplaceAll(text, k, v)
	}
	text = removedSymbolsRE.ReplaceAllString(text, " ")
	return strings.TrimSpace(text)
}
