package i18n

import (
	"strings"

	tanker "a.yandex-team.ru/travel/library/go/tanker/next"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
)

const (
	carTypeKeyPrefix = "cartype"
	dot              = "."
)

type CarType string

type CarTypeTranslator struct {
	keySet                *tanker.KeySet
	linguisticsTranslator *LinguisticsTranslator
}

func NewCarTypeTranslator(keySet *tanker.KeySet, linguisticsTranslator *LinguisticsTranslator) *CarTypeTranslator {
	return &CarTypeTranslator{
		keySet:                keySet,
		linguisticsTranslator: linguisticsTranslator,
	}
}

func (t *CarTypeTranslator) UpdateKeySet(keySet *tanker.KeySet) {
	t.keySet = keySet
}

func (t *CarTypeTranslator) GetTitle(carType CarType, language lang.Lang, grammaticalCase lang.GrammaticalCase) (string, error) {
	if grammaticalCase != lang.Nominative {
		key := strings.Join([]string{carTypeKeyPrefix, string(carType), grammaticalCase.String()}, dot)
		res, err := t.keySet.GetSingular(key, language.String())
		if err == nil {
			return res, nil
		}
	}
	key := strings.Join([]string{carTypeKeyPrefix, string(carType)}, dot)
	return t.keySet.GetSingular(key, language.String())
}

func (t *CarTypeTranslator) GetTitleInLocative(carType CarType, language lang.Lang) (string, error) {
	preposition, err := t.linguisticsTranslator.FindPreposition(language, lang.PrepositionIn, nil)
	if err != nil {
		return "", err
	}
	title, err := t.GetTitle(carType, language, lang.Locative)
	if err != nil {
		return "", err
	}
	return strings.Join([]string{preposition, title}, " "), nil
}

func (t *CarTypeTranslator) GetTitleToAccusative(carType CarType, language lang.Lang) (string, error) {
	preposition, err := t.linguisticsTranslator.FindPreposition(language, lang.PrepositionTo, nil)
	if err != nil {
		return "", err
	}
	title, err := t.GetTitle(carType, language, lang.Accusative)
	if err != nil {
		return "", err
	}
	return strings.Join([]string{preposition, title}, " "), nil
}
