package i18n

import (
	"fmt"
	"strings"
	"time"

	tanker "a.yandex-team.ru/travel/library/go/tanker/next"

	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
)

type DurationTranslator struct {
	keySet *tanker.KeySet
}

func NewDurationTranslator(keySet *tanker.KeySet) *DurationTranslator {
	return &DurationTranslator{
		keySet: keySet,
	}
}

func (t *DurationTranslator) UpdateKeySet(keySet *tanker.KeySet) {
	t.keySet = keySet
}

func (t *DurationTranslator) FormatHumanDuration(language lang.Lang, duration time.Duration) (string, error) {
	days := int(duration / (time.Hour * 24))
	duration = duration % (time.Hour * 24)
	hours := int(duration / time.Hour)
	duration = duration % time.Hour
	minutes := int(duration / time.Minute)
	duration = duration % time.Minute
	seconds := int(duration / time.Second)
	items := make([]string, 0, 5)
	if days != 0 {
		str, err := t.keySet.GetPlural("days", language.String(), days)
		if err != nil {
			return "", fmt.Errorf("error getting key: %w", err)
		}
		items = append(items, fmt.Sprintf("%d %s", days, str))
	}
	if hours != 0 {
		str, err := t.keySet.GetPlural("hours", language.String(), hours)
		if err != nil {
			return "", fmt.Errorf("error getting key: %w", err)
		}
		items = append(items, fmt.Sprintf("%d %s", hours, str))
	}
	if minutes != 0 {
		str, err := t.keySet.GetPlural("minutes", language.String(), minutes)
		if err != nil {
			return "", fmt.Errorf("error getting key: %w", err)
		}
		items = append(items, fmt.Sprintf("%d %s", minutes, str))
	}
	if seconds != 0 {
		str, err := t.keySet.GetPlural("seconds", language.String(), seconds)
		if err != nil {
			return "", fmt.Errorf("error getting key: %w", err)
		}
		items = append(items, fmt.Sprintf("%d %s", seconds, str))
	}
	return strings.Join(items, " "), nil
}
