package i18n

import (
	"encoding/json"
	"fmt"
	"os"

	"a.yandex-team.ru/travel/library/go/tanker"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
)

type Keyset interface {
	ExecuteSingular(key string, language lang.Lang, extraSlice ...map[string]interface{}) (string, error)
}

type FileKeyset struct {
	tankerKeyset tanker.Keyset
}

func (k FileKeyset) ExecuteSingular(key string, language lang.Lang, extraSlice ...map[string]interface{}) (string, error) {
	extra := map[string]interface{}{}
	if len(extraSlice) != 0 {
		extra = extraSlice[0]
	}
	return tanker.TemplateToString(key, k.tankerKeyset.GetSingular(key, string(language)), extra)
}

func ReadKeyset(keysetFilePath string) (keyset FileKeyset, err error) {
	keysetFile, err := os.Open(keysetFilePath)
	if err != nil {
		return keyset, fmt.Errorf("couldn't read tanker keyset from file: %w", err)
	}
	defer keysetFile.Close()

	err = json.NewDecoder(keysetFile).Decode(&keyset.tankerKeyset)
	if err != nil {
		return keyset, fmt.Errorf("couldn't decode keyset json from file: %w", err)
	}
	return keyset, nil
}

var FakeKeyset = &fakeKeyset{}

type fakeKeyset struct{}

func (k fakeKeyset) ExecuteSingular(key string, language lang.Lang, extraSlice ...map[string]interface{}) (string, error) {
	return "Translated: " + key, nil
}
