package i18n

import (
	"fmt"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
)

type Station struct {
	value                 *rasp.TStation
	linguisticsTranslator *LinguisticsTranslator
}

func NewStation(value *rasp.TStation, linguisticsTranslator *LinguisticsTranslator) Station {
	return Station{
		value:                 value,
		linguisticsTranslator: linguisticsTranslator,
	}
}

func (s Station) Preposition(language lang.Lang, preposition lang.Preposition) (string, error) {
	prepositions := lang.Prepositions{
		lang.RuPrepositionTo: s.value.TitleRuPreposition,
		lang.RuPrepositionIn: s.value.TitleRuPreposition,
	}
	pp, err := s.linguisticsTranslator.FindPreposition(language, preposition, []lang.Prepositions{prepositions})
	if err != nil {
		return "", fmt.Errorf("%s fails: %w", "pkg.translations.models.Station.PrepositionTo", err)
	}
	return pp, nil
}

func (s Station) Title(language lang.Lang, grammaticalCase lang.GrammaticalCase) (string, error) {
	title, err := s.linguisticsTranslator.FindLinguisticForm(language, grammaticalCase, []lang.Linguistics{s.getTitleTranslations()})
	if err != nil {
		return "", fmt.Errorf("%s fails: %w", "pkg.translations.models.Station.Title", err)
	}
	return title, nil
}

func (s Station) PopularTitle(language lang.Lang, grammaticalCase lang.GrammaticalCase) (string, error) {
	title, err := s.linguisticsTranslator.FindLinguisticForm(language, grammaticalCase, []lang.Linguistics{
		s.getPopularTitleTranslations(),
		s.getTitleTranslations(),
	})
	if err != nil {
		return "", fmt.Errorf("%s fails: %w", "pkg.translations.models.Station.PopularTitle", err)
	}
	return title, nil
}

func (s Station) getTitleTranslations() lang.Linguistics {
	linguistics := lang.Linguistics{
		lang.RuGenitive:   s.value.TitleRuGenitiveCase,
		lang.RuAccusative: s.value.TitleRuAccusativeCase,
		lang.RuLocative:   s.value.TitleRuPrepositionalCase,
	}

	if s.value.Title != nil {
		linguistics[lang.RuNominative] = s.value.Title.Ru
		linguistics[lang.EnNominative] = s.value.Title.En
		linguistics[lang.TrNominative] = s.value.Title.Tr
		linguistics[lang.UkNominative] = s.value.Title.Uk
	}

	for key, value := range linguistics {
		if value == "" {
			delete(linguistics, key)
		}
	}
	return linguistics
}

func (s Station) getPopularTitleTranslations() lang.Linguistics {
	linguistics := lang.Linguistics{
		lang.RuGenitive: s.value.PopularTitleRuGenitiveCase,
	}

	if s.value.PopularTitle != nil {
		linguistics[lang.RuNominative] = s.value.PopularTitle.Ru
		linguistics[lang.EnNominative] = s.value.PopularTitle.En
		linguistics[lang.TrNominative] = s.value.PopularTitle.Tr
		linguistics[lang.UkNominative] = s.value.PopularTitle.Uk
	}

	for key, value := range linguistics {
		if value == "" {
			delete(linguistics, key)
		}
	}
	return linguistics
}
