package i18n

import (
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
)

type TrainTitleTranslator struct {
	keyset Keyset
}

func NewTrainTitleTranslator(keyset Keyset) *TrainTitleTranslator {
	return &TrainTitleTranslator{
		keyset: keyset,
	}
}

func (t *TrainTitleTranslator) FormatTicketsWithPoints(language lang.Lang, departureTitle, arrivalTitle string) (string, error) {
	const textKey = "train_tickets_from_departure_point_to_arrival_point"

	textParams := map[string]interface{}{
		"departureTitle": departureTitle,
		"arrivalTitle":   arrivalTitle,
	}
	return t.keyset.ExecuteSingular(textKey, language, textParams)
}

func (t *TrainTitleTranslator) FormatBrandSchedule(language lang.Lang, departureTitle, arrivalTitle, brandTitle string) (string, error) {
	const textKey = "brand_schedule"

	textParams := map[string]interface{}{
		"departureTitle": departureTitle,
		"arrivalTitle":   arrivalTitle,
		"brand":          brandTitle,
	}
	return t.keyset.ExecuteSingular(textKey, language, textParams)
}

func (t *TrainTitleTranslator) FormatTrainsSchedule(language lang.Lang, departureTitle, arrivalTitle string) (string, error) {
	const textKey = "trains_schedule"

	textParams := map[string]interface{}{
		"departureTitle": departureTitle,
		"arrivalTitle":   arrivalTitle,
	}
	return t.keyset.ExecuteSingular(textKey, language, textParams)
}

func (t *TrainTitleTranslator) FormatRouteTitleAsRing(language lang.Lang, title string) (string, error) {
	const textKey = "route_title_as_ring"
	return t.formatRouteTitle(textKey, language, title)
}

func (t *TrainTitleTranslator) FormatRouteTitleAsConfirmedTrain(language lang.Lang, title string) (string, error) {
	const textKey = "route_title_as_confirmed_train"
	return t.formatRouteTitle(textKey, language, title)
}

func (t *TrainTitleTranslator) FormatRouteTitleWithTransfer(language lang.Lang, title string) (string, error) {
	const textKey = "route_title_with_transfer"
	return t.formatRouteTitle(textKey, language, title)
}

func (t *TrainTitleTranslator) FormatRouteTitleWithManyTransfers(language lang.Lang, title string) (string, error) {
	const textKey = "route_title_with_many_transfers"
	return t.formatRouteTitle(textKey, language, title)
}

func (t *TrainTitleTranslator) formatRouteTitle(textKey string, language lang.Lang, title string) (string, error) {
	textParams := map[string]interface{}{
		"title": title,
	}
	return t.keyset.ExecuteSingular(textKey, language, textParams)
}
