package i18n

import (
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type TranslatableFactory struct {
	linguisticsTranslator *LinguisticsTranslator
	keyset                Keyset
}

func NewTranslatableFactory(linguisticsTranslator *LinguisticsTranslator, keyset Keyset) *TranslatableFactory {
	return &TranslatableFactory{
		linguisticsTranslator: linguisticsTranslator,
		keyset:                keyset,
	}
}

func (f *TranslatableFactory) TranslatableStation(value *rasp.TStation) Station {
	return NewStation(value, f.linguisticsTranslator)
}

func (f *TranslatableFactory) TranslatableSettlement(value *rasp.TSettlement) Settlement {
	return NewSettlement(value, f.linguisticsTranslator)
}

func (f *TranslatableFactory) TranslatableNamedTrain(value *rasp.TNamedTrain) NamedTrain {
	return NewNamedTrain(value, f.linguisticsTranslator, f.keyset)
}
