package lang

const (
	Ru Lang = "ru"
	En Lang = "en"
	Tr Lang = "tr"
	Uk Lang = "uk"

	Nominative GrammaticalCase = "nominative"
	Genitive   GrammaticalCase = "genitive"
	Accusative GrammaticalCase = "accusative"
	Locative   GrammaticalCase = "locative"
	Dative     GrammaticalCase = "dative"

	PrepositionIn   Preposition = "preposition_in"
	PrepositionFrom Preposition = "preposition_from"
	PrepositionTo   Preposition = "preposition_to"
)

var (
	RuNominative = NewLinguisticForm(Ru, Nominative)
	RuGenitive   = NewLinguisticForm(Ru, Genitive)
	RuAccusative = NewLinguisticForm(Ru, Accusative)
	RuLocative   = NewLinguisticForm(Ru, Locative)
	EnNominative = NewLinguisticForm(En, Nominative)
	TrNominative = NewLinguisticForm(Tr, Nominative)
	UkNominative = NewLinguisticForm(Uk, Nominative)
	UkAccusative = NewLinguisticForm(Uk, Accusative)

	RuPrepositionTo = NewPrepositionForm(Ru, PrepositionTo)
	RuPrepositionIn = NewPrepositionForm(Ru, PrepositionIn)
)

type Lang string

func (l Lang) String() string {
	return string(l)
}

type GrammaticalCase string

func (c GrammaticalCase) String() string {
	return string(c)
}

type Preposition string

func (c Preposition) String() string {
	return string(c)
}

type LinguisticForm struct {
	Lang Lang
	Case GrammaticalCase
}

func NewLinguisticForm(lang Lang, grammaticalCase GrammaticalCase) LinguisticForm {
	return LinguisticForm{Lang: lang, Case: grammaticalCase}
}

type Linguistics map[LinguisticForm]string

type PrepositionForm struct {
	Lang        Lang
	Preposition Preposition
}

func NewPrepositionForm(lang Lang, preposition Preposition) PrepositionForm {
	return PrepositionForm{Lang: lang, Preposition: preposition}
}

type Prepositions map[PrepositionForm]string
