package railway

import (
	"time"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/consts"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/points"
)

func GetLocationByPoint(point points.Point, repoRegistry *registry.RepositoryRegistry) *time.Location {
	tzRepo := repoRegistry.GetTimeZoneRepo()
	if point.Type() == points.StationType {
		station := point.Proto().(*rasp.TStation)
		if location, found := tzRepo.GetLocationByID(station.RailwayTimeZoneId); found {
			return location
		}
	}

	countryID := point.CountryID()

	// В Таджикистане на ЖД московское время
	if countryID == consts.TajikistanID {
		countryID = consts.RussiaID
	}

	if capital, found := repoRegistry.GetSettlementRepo().GetCapitalByCountryID(countryID); found {
		if location, found := tzRepo.GetLocationByID(capital.TimeZoneId); found {
			return location
		}
	}

	return consts.DefaultLocation
}
