package schedule

import (
	"time"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type (
	Segment struct {
		Thread            *rasp.TThread
		ThreadStartDt     time.Time
		Departure         *rasp.TThreadStation
		DepartureDateTime time.Time
		Arrival           *rasp.TThreadStation
		ArrivalDateTime   time.Time
		EventTime         time.Time
		EventLocation     *time.Location
	}
	Segments []*Segment

	rawSegment struct {
		thread              *rasp.TThread
		departure           *rasp.TThreadStation
		departureMajorityID int32
		arrival             *rasp.TThreadStation
		arrivalMajorityID   int32
	}
	rawSegments []*rawSegment
)

type (
	threadToStations map[int][]*rasp.TThreadStation
	pointToStops     map[int]threadToStations
)

func (s pointToStops) addThreadStation(pointID int, threadID int, threadStation *rasp.TThreadStation) {
	if threadStation == nil {
		return
	}

	pointStops, found := s[pointID]
	if !found {
		s[pointID] = make(threadToStations)
		pointStops = s[pointID]
	}

	pointStops[threadID] = append(pointStops[threadID], threadStation)
}
