package schedule

import (
	"time"

	"a.yandex-team.ru/travel/library/go/funcnames"

	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/date"
)

var repositoryFindSegmentsFnCaller funcnames.Caller

func init() {
	repositoryFindSegmentsFnCaller = funcnames.BuildFullName((&Repository{}).FindSegments)
}

func FindFirstDateSegments(segments Segments) (time.Time, Segments) {
	if len(segments) == 0 {
		return time.Time{}, segments
	}

	minEventDate := GetEventDate(segments[0])
	filtered := Segments{segments[0]}
	for _, segment := range segments[1:] {
		eventDate := GetEventDate(segment)
		if eventDate.Equal(minEventDate) {
			filtered = append(filtered, segment)
		}

		if eventDate.Before(minEventDate) {
			minEventDate = eventDate
			filtered = Segments{segment}
		}
	}

	return minEventDate, filtered
}

func GetEventDate(segment *Segment) time.Time {
	return date.DateFromTime(segment.EventTime.In(segment.EventLocation))
}
