package searchprops

import (
	"context"
	"sync"
)

type ctxKey struct{}

var searchPropsCtxKey = new(ctxKey)

type searchProps struct {
	lock   sync.Mutex
	values map[string]interface{}
}

func (props *searchProps) toMap() map[string]interface{} {
	if props == nil {
		return nil
	}

	props.lock.Lock()
	defer props.lock.Unlock()

	result := make(map[string]interface{})
	for k, v := range props.values {
		result[k] = v
	}
	return result
}

func With(ctx context.Context) context.Context {
	return context.WithValue(ctx, &searchPropsCtxKey, &searchProps{
		lock:   sync.Mutex{},
		values: make(map[string]interface{}),
	})
}

func GetMap(ctx context.Context) map[string]interface{} {
	if props, ok := ctx.Value(&searchPropsCtxKey).(*searchProps); ok {
		return props.toMap()
	}
	return nil
}

func Set(ctx context.Context, key string, value interface{}) {
	props, ok := ctx.Value(&searchPropsCtxKey).(*searchProps)
	if !ok || props == nil {
		return
	}

	props.lock.Lock()
	defer props.lock.Unlock()
	props.values[key] = value
}
