package cache

import (
	"time"

	"a.yandex-team.ru/travel/library/go/resourcestorage"
)

type Config struct {
	Enable bool `config:"tariff-cache-enable"`

	SnapshotDumpLockPath string        `config:"tariff-cache-snapshot-dump-lock-path" yaml:"snapshot-dump-lock-path"`
	SnapshotDumpPeriod   time.Duration `config:"tariff-cache-snapshot-dump-period" yaml:"snapshot-dump-period"`
	SnapshotDirectory    string        `config:"tariff-cache-snapshot-directory" yaml:"snapshot-directory"`
	SnapshotKeepLast     int           `config:"tariff-cache-snapshot-keep-last" yaml:"snapshot-keep-last"`
	SnapshotTTL          time.Duration `config:"tariff-cache-snapshot-ttl" yaml:"snapshot-ttl"`
	RemoveExpiredPeriod  time.Duration `config:"tariff-cache-remove-expired-period" yaml:"remove-expired-period"`

	SkipTariffSnapshotLoading bool          `config:"tariff-cache-skip-snapshot-loading" yaml:"skip-tariff-snapshot-loading"`
	S3AccessKey               string        `config:"tariff-cache-s3-access-key,required" yaml:"s3-access-key"`
	S3Secret                  string        `config:"tariff-cache-s3-secret,required" yaml:"s3-secret"`
	S3Storage                 StorageConfig `config:"tariff-cache-s3-secret,required" yaml:"s3-storage"`
}

type StorageConfig struct {
	LocalStoragePath  string `yaml:"local-path"`
	S3StorageEndpoint string `yaml:"endpoint"`
	S3StorageBucket   string `yaml:"bucket"`
	S3StorageRegion   string `yaml:"region"`
}

var DefaultConfig = Config{
	Enable: false,

	SnapshotDumpPeriod:  time.Hour,
	SnapshotDirectory:   "search-api/tariff-cache-snapshots",
	SnapshotKeepLast:    5,
	SnapshotTTL:         20 * time.Hour,
	RemoveExpiredPeriod: 5 * time.Minute,

	SkipTariffSnapshotLoading: false,
	S3Storage:                 StorageConfig(resourcestorage.DefaultS3StorageConfig),
}
