package cache

import (
	"container/heap"
	"time"
)

type TariffExpirations struct {
	container tariffExpirationsHeap
}

func NewTariffExpirations() TariffExpirations {
	return TariffExpirations{
		container: make(tariffExpirationsHeap, 0),
	}
}

func (e *TariffExpirations) Empty() bool {
	return e.container.Len() == 0
}

func (e TariffExpirations) Head() *tariffExpiration {
	if e.Empty() {
		return nil
	}
	return e.container[0]
}

func (e *TariffExpirations) Push(expiration *tariffExpiration) {
	heap.Push(&e.container, expiration)
}

func (e *TariffExpirations) Pop() *tariffExpiration {
	if e.Empty() {
		return nil
	}
	return heap.Pop(&e.container).(*tariffExpiration)
}

type tariffExpiration struct {
	expireAt time.Time
	routeKey tariffRouteKey
}

type tariffExpirationsHeap []*tariffExpiration

func (e tariffExpirationsHeap) Len() int {
	return len(e)
}

func (e tariffExpirationsHeap) Swap(i, j int) {
	e[i], e[j] = e[j], e[i]
}

func (e tariffExpirationsHeap) Less(i, j int) bool {
	return e[i].expireAt.Before(e[j].expireAt)
}

func (e *tariffExpirationsHeap) Push(x interface{}) {
	expiration := x.(*tariffExpiration)
	*e = append(*e, expiration)
}

func (e *tariffExpirationsHeap) Pop() interface{} {
	expiration := (*e)[len(*e)-1]
	(*e)[len(*e)-1] = nil // to avoid memory leaks
	*e = (*e)[:len(*e)-1]
	return expiration
}
