package cache

import (
	"context"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/logbroker"
	"a.yandex-team.ru/travel/trains/search_api/api/tariffs"
)

func RunConsuming(ctx context.Context, cache *TariffCache, consumer *logbroker.Consumer, logger log.Logger) {
	const fnPath = "trains.search_api.internal.pkg.tariff.cache.RunConsuming"

	channel := consumer.NewChannel()
	defer func() { _ = consumer.CloseChannel(channel) }()

	for {
		tariffInfo := new(tariffs.DirectionTariffInfo)
		if err := channel.Read(tariffInfo); err != nil {
			logger.Errorf("%s: can not read tariff info: %v", fnPath, err)
			select {
			case <-time.After(time.Second):
				continue
			case <-ctx.Done():
				logger.Infof("%s: stopped", fnPath)
				return
			}
		}
		cache.Add(tariffInfo)
	}
}
