package cache

import (
	"a.yandex-team.ru/library/go/core/metrics"
	tm "a.yandex-team.ru/travel/library/go/metrics"
)

const metricsPrefix = "tariff_cache"

type cacheMetrics struct {
	errors             metrics.Counter
	cachedTariffsCount metrics.Gauge
}

func newCacheMetrics() *cacheMetrics {
	am := tm.GlobalAppMetrics()
	return &cacheMetrics{
		errors:             am.GetOrCreateCounter(metricsPrefix, nil, "errors"),
		cachedTariffsCount: am.GetOrCreateGauge(metricsPrefix, nil, "count"),
	}
}
