package tariffs

import (
	"context"
	"time"

	"github.com/stretchr/testify/mock"

	api "a.yandex-team.ru/travel/trains/search_api/api/tariffs"
)

type TrainTariffProviderMock struct {
	mock.Mock
}

func (m *TrainTariffProviderMock) Select(
	ctx context.Context,
	departurePointExpressID []int32,
	arrivalPointExpressID []int32,
	leftBorder time.Time,
	rightBorder time.Time,
) ([]*api.DirectionTariffInfo, error) {
	args := m.Called(ctx, departurePointExpressID, arrivalPointExpressID, leftBorder, rightBorder)
	return args.Get(0).([]*api.DirectionTariffInfo), args.Error(1)
}

func (m *TrainTariffProviderMock) SelectByDirections(
	ctx context.Context,
	directions []TrainDirection,
	leftBorder time.Time, // local departure station date
	rightBorder time.Time, // local departure station date
) ([]*api.DirectionTariffInfo, error) {
	args := m.Called(ctx, directions, leftBorder, rightBorder)
	return args.Get(0).([]*api.DirectionTariffInfo), args.Error(1)
}
