package tariffs

import (
	"context"
	"time"

	api "a.yandex-team.ru/travel/trains/search_api/api/tariffs"
)

type TrainDirection struct {
	DeparturePointExpressID int32
	ArrivalPointExpressID   int32
}

type TrainTariffSaver interface {
	SaveDirectionTariff(tariff *api.DirectionTariffInfo) error
}

type TrainTariffSelector interface {
	Select(
		ctx context.Context,
		departurePointExpressID []int32,
		arrivalPointExpressID []int32,
		leftBorder time.Time, // local departure station date
		rightBorder time.Time, // local departure station date
	) ([]*api.DirectionTariffInfo, error)
}

type TrainTariffByDirectionsSelector interface {
	SelectByDirections(
		ctx context.Context,
		directions []TrainDirection,
		leftBorder time.Time, // local departure station date
		rightBorder time.Time, // local departure station date
	) ([]*api.DirectionTariffInfo, error)
}

type TrainTariffProvider interface {
	TrainTariffSelector
	TrainTariffByDirectionsSelector
}
