package templater

import (
	"fmt"
	"reflect"
	"strings"

	"github.com/flosch/pongo2/v4"
)

func init() {
	err := pongo2.RegisterFilter("join_last", joinLastFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("nominative", nominativeFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("genitive", genitiveFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("dative", dativeFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("accusative", accusativeFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("prepositional", prepositionalFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("preposition_to", prepositionToFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("preposition_in", prepositionInFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("locative", locativeFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("directional", directionalFilter)
	if err != nil {
		panic(err)
	}
	err = pongo2.RegisterFilter("ablative", ablativeFilter)
	if err != nil {
		panic(err)
	}
}

func InitTemplate(templateStr string) (*pongo2.Template, error) {
	templateStr = strings.ReplaceAll(templateStr, "\n", "")
	return pongo2.FromString(templateStr)
}

func ExecuteTemplate(t *pongo2.Template, data interface{}) (string, error) {
	dataMap, err := StructToMap(data)
	if err != nil {
		return "", err
	}
	return t.Execute(dataMap)
}

func StructToMap(source interface{}) (map[string]interface{}, error) {
	result := make(map[string]interface{})
	sType := reflect.TypeOf(source)
	sValue := reflect.ValueOf(source)
	isPtr := sType.Kind() == reflect.Ptr
	if isPtr {
		sType = sType.Elem()
		sValue = sValue.Elem()
	}
	if sType.Kind() != reflect.Struct {
		return nil, fmt.Errorf("expected Struct type, but %v found", sType.Kind())
	}
	for i := 0; i < sType.NumField(); i++ {
		fieldName := sType.Field(i).Name
		result[fieldName] = sValue.FieldByName(fieldName).Interface()
	}
	return result, nil
}
