package updater

import (
	"fmt"
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
	tm "a.yandex-team.ru/travel/library/go/metrics"
)

type updaterMetrics struct {
	updateSuccessCount metrics.Counter
	updateErrorCount   metrics.Counter
	updateDuration     metrics.Timer
}

func newUpdaterMetrics(code string) *updaterMetrics {
	durationBuckets := metrics.NewDurationBuckets(
		2*time.Millisecond,
		10*time.Millisecond,
		50*time.Millisecond,
		250*time.Millisecond,
		1*time.Second,
		3*time.Second,
		10*time.Second,
	)
	am := tm.GlobalAppMetrics()

	loadPrefix := fmt.Sprintf("%s.load", code)
	return &updaterMetrics{
		updateSuccessCount: am.GetOrCreateCounter(loadPrefix, nil, "count"),
		updateErrorCount:   am.GetOrCreateCounter(loadPrefix, nil, "errors_count"),
		updateDuration:     am.GetOrCreateHistogram(loadPrefix, nil, "duration", durationBuckets),
	}
}
