package url

import (
	"fmt"
	"net/url"
)

const trainPrefix = "trains"

type Factory struct {
	schema     string
	tldURLMap  map[string]string
	defaultURL string
}

func NewFactory(trainURL string) *Factory {
	hostMap := map[string]string{
		"ru": trainURL,
		"ua": trainURL,
		"kz": trainURL,
		"by": trainURL,
		"uz": trainURL,
	}
	return &Factory{
		schema:     "https",
		tldURLMap:  hostMap,
		defaultURL: trainURL,
	}
}

type Slugger interface {
	Slug() string
}

func (f *Factory) MakeSearchURL(fromPoint Slugger, toPoint Slugger, when string, tld string, hasVariants bool, mainReqID *string, extra extraMap) string {
	extra = copyExtra(extra)
	if mainReqID != nil {
		extra.add("wizardReqId", *mainReqID)
	}

	var path string
	if hasVariants {
		path = fmt.Sprintf("%s/%s--%s/", trainPrefix, fromPoint.Slug(), toPoint.Slug())
		extra.add("when", when)
	} else {
		path = fmt.Sprintf("%s/", trainPrefix)
	}

	searchURL, _ := url.Parse(fmt.Sprintf("%s/%s", f.getURL(tld), path))
	encodeExtra(searchURL, extra)
	return searchURL.String()
}

func (f *Factory) MakeServiceURL(tld string, mainReqID *string) string {
	extra := make(extraMap)
	if mainReqID != nil {
		extra.add("wizardReqId", *mainReqID)
	}

	path := fmt.Sprintf("%s/", trainPrefix)
	serviceURL, _ := url.Parse(fmt.Sprintf("%s/%s", f.getURL(tld), path))
	encodeExtra(serviceURL, extra)
	return serviceURL.String()
}

func (f *Factory) MakeHost(tld string) string {
	searchURL, _ := url.Parse(f.getURL(tld))
	return fmt.Sprintf("%s/%s/", searchURL.Host, trainPrefix)
}

func (f *Factory) MakeOrderContextURL(tld string, extra extraMap) OrderURLContext {
	orderURL, _ := url.Parse(fmt.Sprintf("%s/%s/order/", f.getURL(tld), trainPrefix))
	return OrderURLContext{
		extra: extra,
		url:   orderURL,
	}
}

func (f *Factory) getURL(tld string) string {
	if host, found := f.tldURLMap[tld]; found {
		return host
	}
	return f.defaultURL

}

func (f *Factory) getRoutePath(fromPoint Slugger, toPoint Slugger) string {
	return fmt.Sprintf("%s/%s--%s", trainPrefix, fromPoint.Slug(), toPoint.Slug())
}
