package url

import (
	"net/url"
	"time"
)

type OrderURLContext struct {
	extra extraMap
	url   *url.URL
}

func (c OrderURLContext) WithSegmentInfo(trainNumber string, provider string, departureDateTime time.Time) OrderURLContext {
	newExtra := copyExtra(c.extra)
	newExtra.add("number", trainNumber)
	newExtra.add("time", departureDateTime.Format("15:04"))
	if len(provider) > 0 {
		newExtra.add("provider", provider)
	}

	return OrderURLContext{
		extra: newExtra,
		url:   c.url,
	}
}

func (c OrderURLContext) String() string {
	urlCopy := *c.url
	encodeExtra(&urlCopy, c.extra)
	return urlCopy.String()
}

func copyExtra(extra extraMap) extraMap {
	newExtra := make(extraMap)
	for k, v := range extra {
		newExtra[k] = v
	}
	return newExtra
}
