package url

import "net/url"

type extraMap map[string][]string

func encodeExtra(searchURL *url.URL, extra extraMap) {
	query := searchURL.Query()
	for key, values := range extra {
		for _, value := range values {
			query.Add(key, value)
		}
	}
	searchURL.RawQuery = query.Encode()
}

func (extra extraMap) add(key, value string) {
	extra[key] = append(extra[key], value)
}
