package models

import (
	commonModels "a.yandex-team.ru/travel/trains/library/go/httputil/clients/common/models"
	mbModels "a.yandex-team.ru/travel/trains/library/go/httputil/clients/mordabackend/models"
)

type TransferVariant struct {
	ID       string
	Forward  []commonModels.SegmentWithTariffs
	Backward []commonModels.SegmentWithTariffs
	OrderURL TransferVariantOrderURL
	MinPrice commonModels.Price
}

type TransferVariantsResponse struct {
	Context          mbModels.ResponseContext
	Querying         bool
	TransferVariants []TransferVariant
	ActivePartners   []string
	NearestDays      NearestDates
}

const (
	OrderOwnerUnknown = iota
	OrderOwnerTrains
	OrderOwnerUFS
)

type TransferVariantOrderURL struct {
	Owner int
	URL   string
}

type UserArgs struct {
	IsBot           bool
	UaasExperiments string
	Icookie         string
	UserDevice      string
	YandexUID       string
}

type TestContext struct {
	MockImAuto bool
	MockImPath string
}

const (
	NearestDatesReasonUnknown = iota
	NearestDatesReasonNoDirectTrains
	NearestDatesReasonNoRequestedDateDirectTrains
)

type NearestDate struct {
	Date string
}

type NearestDatesDirection struct {
	Reason int
	Dates  []NearestDate
}

type NearestDates struct {
	Forward  NearestDatesDirection
	Backward NearestDatesDirection
}
