package seo

import "a.yandex-team.ru/travel/library/go/resourcestorage"

type Config struct {
	SnapshotDirectory string        `config:"seo-snapshot-directory" yaml:"snapshot-directory"`
	S3AccessKey       string        `config:"seo-s3-access-key,required" yaml:"s3-access-key"`
	S3Secret          string        `config:"seo-s3-secret,required" yaml:"s3-secret"`
	S3Storage         StorageConfig `config:"seo-s3-secret,required" yaml:"s3-storage"`
}

var DefaultConfig = Config{
	SnapshotDirectory: "search-api/seo-tanker-snapshots",
	S3Storage:         StorageConfig(resourcestorage.DefaultS3StorageConfig),
}

type StorageConfig struct {
	LocalStoragePath  string `yaml:"local-path"`
	S3StorageEndpoint string `yaml:"endpoint"`
	S3StorageBucket   string `yaml:"bucket"`
	S3StorageRegion   string `yaml:"region"`
}
