package seo

import "fmt"

type PointNotFoundError struct {
	paramName string
	slug      string
}

func (e *PointNotFoundError) Error() string {
	return fmt.Sprintf("%s: point %s not found", e.paramName, e.slug)
}

type EmptyDirectionError struct {
	fromSlug string
	toSlug   string
}

func (e *EmptyDirectionError) Error() string {
	return fmt.Sprintf("not found trains by direction %s - %s", e.fromSlug, e.toSlug)
}
